<?php
/**
 * Translate a result array into a HTML table
 *
 * @author      Aidan Lister <aidan@php.net>
 * @version     1.3.2
 * @link        http://aidanlister.com/2004/04/converting-arrays-to-human-readable-tables/
 * @param       array  $array      The result (numericaly keyed, associative inner) array.
 * @param       bool   $recursive  Recursively generate tables for multi-dimensional arrays
 * @param       string $null       String to output for blank cells
 */
function array2table($array, $recursive = false, $null = '&nbsp;')
{
    // Sanity check
    if (empty($array) || !is_array($array)) {
        return false;
    }

    if (!isset($array[0]) || !is_array($array[0])) {
        $array = array($array);
    }

    // Start the table
    $table = "<table>\n";

    // The header
    $table .= "\t<tr>";
    // Take the keys from the first row as the headings
    foreach (array_keys($array[0]) as $heading) {
        $table .= '<th>' . $heading . '</th>';
    }
    $table .= "</tr>\n";

    // The body
    foreach ($array as $row) {
        $table .= "\t<tr>" ;
        foreach ($row as $cell) {
            $table .= '<td>';

            // Cast objects
            if (is_object($cell)) { $cell = (array) $cell; }
            
            if ($recursive === true && is_array($cell) && !empty($cell)) {
                // Recursive mode
                $table .= "\n" . array2table($cell, true, true) . "\n";
            } else {
                if (is_array($cell) && !empty($cell))
                {
                    $table .= (strlen($cell) > 0) ?
                    htmlspecialchars((string) $cell) :
                    $null;
                }
                else
                {
                   $null; 
                }
                
            }

            $table .= '</td>';
        }

        $table .= "</tr>\n";
    }

    $table .= '</table>';
    return $table;
}

/**
 * Check if the value is a valid date
 *
 * @param mixed $value
 *
 * @return boolean
 */
function isDate($value) 
{
    if (!$value) {
        return false;
    }

    try {
        new \DateTime($value);
        return true;
    } catch (\Exception $e) {
        return false;
    }
}


function do_offset($level){
    $offset = "";             // offset for subarry 
    for ($i=1; $i<$level;$i++){
    $offset = $offset . "<td></td>";
    }
    return $offset;
}

function show_array($array, $level, $sub){
    if (is_array($array) == 1){          // check if input is an array
       foreach($array as $key_val => $value) {
           $offset = "";
           if (is_array($value) == 1){   // array is multidimensional
           echo "<tr>";
           $offset = do_offset($level);
           echo $offset . "<td>" . $key_val . "</td>";
           show_array($value, $level+1, 1);
           }
           else{                        // (sub)array is not multidim
           if ($sub != 1){          // first entry for subarray
               echo "<tr nosub>";
               $offset = do_offset($level);
           }
           $sub = 0;
           echo $offset . "<td main ".$sub." width=\"120\">" . $key_val . 
               "</td><td width=\"120\">" . $value . "</td>"; 
           echo "</tr>\n";
           }
       } //foreach $array
    }  
    else{ // argument $array is not an array
        return;
    }
}

function html_show_array($array){
  echo "<table cellspacing=\"0\" border=\"2\">\n";
  show_array($array, 2, 1);
  echo "</table>\n";
}

function redirect($url) 
    {
        ob_start();
        header('Location: '.$url);
        ob_end_flush();
        die();
    } 
    
// Determine whether the page was requested by GET or POST.
function isPostBack()
{
    return ($_SERVER['REQUEST_METHOD'] == 'POST');
}

function array_to_table($data,$args=false) 
{

	if (!is_array($args)) { $args = array(); }
	foreach (array('class','column_widths','custom_headers','format_functions','nowrap_head','nowrap_body','capitalize_headers') as $key) {
		if (array_key_exists($key,$args)) { $$key = $args[$key]; } else { $$key = false; }
	}
	if ($class) { $class = ' class="'.$class.'"'; } else { $class = ''; }
	if (!is_array($column_widths)) { $column_widths = array(); }

    //get rid of headers row, if it exists (headers should exist as keys)
    if (array_key_exists('headers',$data)) { unset($data['headers']); }

	$t = '<table'.$class.'>';
	$i = 0;
	foreach ($data as $row) {
		$i++;
		//display headers
		if ($i == 1) { 
			foreach ($row as $key => $value) {
				if (array_key_exists($key,$column_widths)) { $style = ' style="width:'.$column_widths[$key].'px;"'; } else { $style = ''; }
				$t .= '<col'.$style.' />';
			}
			$t .= '<thead><tr>';
			foreach ($row as $key => $value) {
				if (is_array($custom_headers) && array_key_exists($key,$custom_headers) && ($custom_headers[$key])) { $header = $custom_headers[$key]; }
				elseif ($capitalize_headers) { $header = ucwords($key); }
				else { $header = $key; }
				if ($nowrap_head) { $nowrap = ' nowrap'; } else { $nowrap = ''; }
				$t .= '<td'.$nowrap.'>'.$header.'</td>';
			}
			$t .= '</tr></thead>';
		}

		//display values
		if ($i == 1) { $t .= '<tbody>'; }
		$t .= '<tr>';
		foreach ($row as $key => $value) {
			if (is_array($format_functions) && array_key_exists($key,$format_functions) && ($format_functions[$key])) {
				$function = $format_functions[$key];
				if (!function_exists($function)) { custom_die('Data format function does not exist: '.htmlspecialchars($function)); }
				$value = $function($value);
			}
			if ($nowrap_body) { $nowrap = ' nowrap'; } else { $nowrap = ''; }
			$t .= '<td'.$nowrap.'>'.$value.'</td>';
		}
		$t .= '</tr>';
	}
	$t .= '</tbody>';
	$t .= '</table>';
	return $t;
}
?>