<?php
    require_once('Queries.php');
    date_default_timezone_set('Africa/Johannesburg');
    
    function GetRoundResultsWeb($Date, $Round)
    {
        //echo "WebRequest" ."<br>";
        $ctx = stream_context_create(array('http'=>
            array(
                'timeout' => 1200,  //1200 Seconds is 2 Minutes
            )
        ));
        
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $SelectedDate = $Date;
        $split_date = explode("-", $SelectedDate);
        $Year = $split_date[0];
        
        // $Year = $date->format("Y");

        //install the handler
        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });

        //$file = "http://ergast.com/api/f1/2018";
        $file = "http://ergast.com/api/f1/$Year/$Round/results.json";
        $file = str_replace(' ','',$file);

        //echo "WebRequest  file : $file selected date:$SelectedDate" ."<br>";

        $error = 0;
        
        try {
            $jsondata = file_get_contents($file, false, $ctx);
        } catch (Exception $e) {
            $error = 1;
            //echo 'Caught exception: ',  $e->getMessage(), "\n";
        }
        
        // $jsonIterator = new RecursiveIteratorIterator(
        //     new RecursiveArrayIterator(json_decode($jsondata, true)),
        //     RecursiveIteratorIterator::SELF_FIRST);
        
        // foreach ($jsonIterator as $key => $val) {
        //     if(is_array($val)) {
        //         echo "$key:"."<br>";
        //     } else {
        //         echo "$key => $val"."<br>";
        //     }
        // }

        
        

        if ($error == 0)
        {
            try {
                $json = json_decode($jsondata, true); 
                $Season = $json['MRData']['RaceTable']['season'];
                $Round = $json['MRData']['RaceTable']['round'] ;
                $Country = $json['MRData']['RaceTable']['Races'][0]['Circuit']['Location']['country'];
            } catch (Exception $e) {
                $error = 1;
                //echo 'Caught exception: ',  $e->getMessage(), "\n";
            }

            if ($error == 0)
            {
                DeleteTempRaceResults($Date, $Round);
                
                try {
                    foreach ($json['MRData']['RaceTable']['Races'][0]['Results'] as $key ) 
                    {
                        $Position = $key['position'];
                        $Points = $key['points'];
                        $Name = utf8_decode($key['Driver']['givenName']." ".$key['Driver']['familyName']);
                        $FastLapRank = $key['FastestLap']['rank'];
                    
                        UpdateTempRaceResults2($Season,$Country,$Position,$Round,$Name,$Points);


                        if ($FastLapRank == 1)
                        {
                            UpdateTempRaceResults2($Season,$Country,99,$Round,$Name,0);
                        }


                    }
                } catch (Exception $e) {
                    $error = 1;
                    //echo 'Caught exception: ',  $e->getMessage(), "\n";
                }
            }
        }
    }

    function GetRoundDriverStandingsWeb($Date)
    {
        //echo "WebRequest  GetRoundDriverStandingsWeb" ."<br>";

        $ctx = stream_context_create(array('http'=>
            array(
                'timeout' => 1200,  //1200 Seconds is 2 Minutes
            )
        ));

        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $SelectedDate = $Date;
        $split_date = explode("-", $SelectedDate);
        $Year = $split_date[0];
        
        // $Year = $date->format("Y");

        //install the handler
        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });

        //$file = "http://ergast.com/api/f1/current/driverStandings.json";
        $file = "http://ergast.com/api/f1/$Year/driverStandings.json";
        $file = str_replace(' ','',$file);

        //echo "WebRequest  file : [$file] selected date: [$SelectedDate]" ."<br>";

        $error = 0;
        
        try {
            $jsondata = file_get_contents($file, false, $ctx);
        } catch (Exception $e) {
            $error = 1;
            //echo "Caught exception: " .$e->getMessage() ."<br>";
        }

        if ($error == 0)
        {     
            $json = json_decode($jsondata, true); 

            try {
                $Season = $json['MRData']['StandingsTable']['season'];
            } catch (Exception $e) {
                $error = 1;
                echo 'Caught exception: ',  $e->getMessage(), "\n";
            }

            if ($error == 0)
            {
                try 
                {       
                    foreach ($json['MRData']['StandingsTable']['StandingsLists'][0]['DriverStandings'] as $key ) 
                    {
                        $Position = $key['position'];
                        $Points = $key['points'];
                        $wins = $key['wins'];
                        $Name = utf8_decode($key['Driver']['givenName']." ".$key['Driver']['familyName']);
                        $Nationality = utf8_decode($key['Driver']['nationality']);

                        $DriverStandingsrtc[] = array(
                            'Season' => $Season,
                            'Position' => $Position,
                            'Wins' => $wins,
                            'Points' => $Points,
                            'Name' => $Name,
                            'Nationality' => $Nationality
                        );
                        
                    }
                } catch (Exception $e) {
                    $error = 1;
                    //echo 'Caught exception: ',  $e->getMessage(), "\n";
                }
            }
        }

        if (isset($DriverStandingsrtc))
        {
            return $DriverStandingsrtc;
        }
        else
        {
            return null;
        }
        
    }  

    function GetRoundDriverStandingsWeb2($Date, &$ErrorMessage)
    {        
        $ErrorMessage = "";
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $SelectedDate = $Date;
        $split_date = explode("-", $SelectedDate);
        $Year = $split_date[0];
        
        // $Year = $date->format("Y");

        //install the handler
        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });

        //$file = "http://ergast.com/api/f1/current/driverStandings.json";
        $file = "http://ergast.com/api/f1/$Year/driverStandings.json";
        $file = str_replace(' ','',$file);

        //echo "WebRequest  file : [$file] selected date: [$SelectedDate]" ."<br>";

        $error = 0;
        
        $curl = curl_init();
        // Set some options - we are passing in a useragent too here
        curl_setopt_array($curl, array(
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_URL => $file,
            CURLOPT_USERAGENT => 'Codular Sample cURL Request'
        ));
        // Send the request & save response to $resp
        $resp = curl_exec($curl);
        if(!$resp)
        {
            //echo 'Error: "' . curl_error($curl) . '" - Code: ' . curl_errno($curl)."<br/>";
            $ErrorMessage = 'Error: ' . curl_error($curl) . ' - Code: ' . curl_errno($curl);
            //echo $ErrorMessage;
            $error = 1;
        }
        // Close request to clear up some resources
        curl_close($curl);


        if ($error == 0)
        {     
            $json = json_decode($resp, true); 

            try {
                $Season = $json['MRData']['StandingsTable']['season'];
            } catch (Exception $e) {
                $error = 1;
                echo 'Caught exception: ',  $e->getMessage(), "\n";
            }

            if ($error == 0)
            {
                try 
                {       
                    foreach ($json['MRData']['StandingsTable']['StandingsLists'][0]['DriverStandings'] as $key ) 
                    {
                        $Position = $key['position'];
                        $Points = $key['points'];
                        $wins = $key['wins'];
                        $Name = utf8_decode($key['Driver']['givenName']." ".$key['Driver']['familyName']);
                        $Nationality = utf8_decode($key['Driver']['nationality']);

                        $DriverStandingsrtc[] = array(
                            'Season' => $Season,
                            'Position' => $Position,
                            'Wins' => $wins,
                            'Points' => $Points,
                            'Name' => $Name,
                            'Nationality' => $Nationality
                        );
                        
                    }
                } catch (Exception $e) {
                    $error = 1;
                    //echo 'Caught exception: ',  $e->getMessage(), "\n";
                }
            }
        }


        if (isset($DriverStandingsrtc))
        {
            return $DriverStandingsrtc;
        }
        else
        {
            return null;
        }
        
    }  

    function GetRoundResultsWeb2($Date, $Round, &$ErrorMessage)
    {
        //install the handler
        // set_error_handler(function($errno, $errstr, $errfile, $errline ){
        //     throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        // });
        $ErrorMessage = "";
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $SelectedDate = $Date;
        $split_date = explode("-", $SelectedDate);
        $Year = $split_date[0];
        
        // $Year = $date->format("Y");
        
        //$file = "http://ergast.com/api/f1/2018";
        $file = "http://ergast.com/api/f1/$Year/$Round/results.json";
        $file = str_replace(' ','',$file);

        //echo "WebRequest  file : $file selected date:$SelectedDate" ."<br>";

        $error = 0;
        
        $curl = curl_init();
        // Set some options - we are passing in a useragent too here
        curl_setopt_array($curl, array(
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_URL => $file,
            CURLOPT_USERAGENT => 'Codular Sample cURL Request'
        ));
        // Send the request & save response to $resp
        $resp = curl_exec($curl);
        if(!$resp)
        {
            //echo 'Error: "' . curl_error($curl) . '" - Code: ' . curl_errno($curl)."<br/>";
            $ErrorMessage = 'Error: "' . curl_error($curl) . '" - Code: ' . curl_errno($curl);
            
            $error = 1;
        }
        // Close request to clear up some resources
        curl_close($curl);

        if ($error == 0)
        {
            try {
                $json = json_decode($resp, true); 
                $Season = $json['MRData']['RaceTable']['season'];
                $Round = $json['MRData']['RaceTable']['round'] ;

                if (sizeof($json['MRData']['RaceTable']['Races']) > 0)
                {
                     $Country = $json['MRData']['RaceTable']['Races'][0]['Circuit']['Location']['country'];
                }
                else
                {
                    $ErrorMessage = "No data for Round $Round season  $Season.";            
                    $error = 1;
                }
               
            } 
            catch (Exception $e) {
                $ErrorMessage = 'Error: Exception.';
            
                $error = 1;
                //echo 'Caught exception: ',  $e->getMessage(), "\n";
            }

            if ($error == 0)
            {
                try 
                {
                    if (sizeof($json['MRData']['RaceTable']['Races']) > 0)
                    {
                        DeleteTempRaceResults($Date, $Round);

                        foreach ($json['MRData']['RaceTable']['Races'][0]['Results'] as $key ) 
                        {
                            $Position = $key['position'];
                            $Points = $key['points'];
                            $Name = utf8_decode($key['Driver']['givenName']." ".$key['Driver']['familyName']);
                            $FastLapRank = $key['FastestLap']['rank'];
                        
                            UpdateTempRaceResults2($Season,$Country,$Position,$Round,$Name,$Points);

                            if ($FastLapRank == 1)
                            {
                                UpdateTempRaceResults2($Season,$Country,99,$Round,$Name,0);
                            }
                        }
                    }
                    else
                    {
                        $ErrorMessage = 'No Data Available.';
                    }
                } 
                catch (Exception $e) 
                {
                    $ErrorMessage = 'Error: Exception.';
                    $error = 1;
                    //echo 'Caught exception: ',  $e->getMessage(), "\n";
                }
            }
        }
    }
?>