<?php
    require_once("db/MySQLDb.php");
    require_once("functions.php");

    function UserDetails($UserName, $UserPassword)
    {
        $sql = "SELECT * FROM regform WHERE userName = '$UserName' and `password` = '$UserPassword'";
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
    }

    function GetUsers()
    {
        $sql = "SELECT username, `NAME` FROM regform WHERE USER_ENABLED = 1 order by `NAME`";
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
    }

    function InsertIntoDB(&$formvars, &$Error)
    {
        $Error = "";
        $insert_query = "insert into regform (
            `username`, `NAME`, `email`, `USER_ENABLED`, `password`, `phoneno`
                )
                values
                ( '" . $formvars['username']   ."',"
				."'" . $formvars['name'] ."'," 
				."'" . $formvars['email'] ."'," 
				."1," 
                ."'" . $formvars['password'] ."'," 
                ."'" . $formvars['phoneNumber'] ."'"
				.")";    

		// echo "<p>$insert_query</p>\n";
		
		if(!IsFieldUnique($formvars,'username'))
        {
            return false;
        }
        
        $db1 = new MySQLDb();
        if(!$db1 -> query($insert_query))
	    // if(!mysqli_query( $GLOBALS['db'], $insert_query))
        {
            //$this->HandleDBError("Error inserting data to the table\nquery:$insert_query");
			$Error = " Error: " .$insert_query .$db1 -> db_error();	
            return false;
        }        
        return true;
    }

    function IsFieldUnique($formvars,$fieldname)
    {
        // $field_val = SanitizeForSQL($formvars[$fieldname]);
        $field_val = $formvars[$fieldname];
        $qry = "select username from regform where $fieldname='".$field_val."'";
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($qry);
        
        if(count($rows) > 0)
        {
            return false;
        }
        return true;
    }

    function UserInfo($UserName, &$Error)
    {
        $Error = "";        
        $sql = "select * from regform WHERE username = '$UserName'";
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }

        return null;
    }

    function GetTeams()
    {
        $sql = "SELECT * FROM teams order by Name";
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;

    }


    function GetDrivers()
    {
        $Date = null;
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));            
        }
        
        $split_date = explode("-", $Date);
        $Season = $split_date[0];

        $sql = "SELECT * FROM drivers where Season = " .$Season. " order by Name";
        // $sql = "SELECT * FROM drivers  order by Name";
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;

    }

    function GetRaces()
    {
        $Racesrtc = null;
        $Date = null;
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));            
        }
        
        $split_date = explode("-", $Date);
        $Season = $split_date[0];

        $sql = "SELECT * FROM races where `Season` = '" .$Season."' order by `Date`";
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }

    function GetRacesRound($Round, $Date)
    {
        if( $Round==null) 
        {
            $Round = 0;
        }

        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));            
        }
        
        $split_date = explode("-", $Date);
        $Season = $split_date[0];

        $sql = "SELECT * FROM races where Season = $Season and Round = $Round order by Date;";
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }

    function GetUserSelection($UserName, $Round, $Date)
    {
        if( $Round==null) 
        {
            $Round = 0;
        }

        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));            
        }
        
        $split_date = explode("-", $Date);
        $Season = $split_date[0];
        // echo "date(\"Y-m-d H:i:s\")".date("Y-m-d H:i:s")."<br>";
        // date_default_timezone_set("UTC");
        // echo date("Y-m-d H:i:s", time())."<br>"; 
        // echo gmdate('Y-m-d H:m:s \G\M\T', time())."<br>";

        //echo "GetUserSelection : $UserName, $Round" ."<br>";
        $sql = "SELECT  r.Round ,us.UserName, us.DateTime, us.1stPlace,  "
        ." us.2ndPlace, us.3rdPlace, us.FatestLap  "
        ." ,CONCAT(`Date`,' ',`Time`) as raceTime,  sysdate(3) as TimeNow, "
        ." case "
        ."     when DATE_ADD(CONCAT(`Date`,' ',`Time`), INTERVAL 5 MINUTE) > sysdate(3) then 1 "
        ."     else 0 "
        ." end as UserCanChange "
        ." FROM (races r "
        ." left join userselection us "
        ." on us.Round = r.Round"
        ." and us.UserName = \"$UserName\" "
        ." and  us.Season = r.Season )"
        ." WHERE r.Round = $Round "
        ." and r.Season = $Season;";
        //  echo "GetUserSelection : " .$sql ."<br>";

        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }

    function GetRoundNumber($Date)
    {
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));            
        }
        
        $split_date = explode("-", $Date);
        $Season = $split_date[0];

        $sql = "SELECT MIN(Round) as minRoundVal FROM races 
        WHERE Date >= \"" .$Date ."\" and Season = ".$Season;
        //echo "GetRoundNumber : " .$sql ."<br>";
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows[0]['minRoundVal'];
            }
        }
        return 0;
        
    }

    function GetMaxRoundNumber($Date)
    {
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));            
        }
        
        $split_date = explode("-", $Date);
        $Season = $split_date[0];

        $sql = "SELECT * 
        FROM races
        where `Round` = (
        select max(`Round`) from  races where Season = ".$Season.")
        and Season = ".$Season;
        

        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return 0;
        
    }


    function UpdateUserselection($UserName,  $Date, $Round
                                , $stPlace, $ndPlace
                                , $rdPlace, $UserFatestLap, $Admin = 0)
    {
        $DateNow = date('Y-m-d H:i:s', strtotime("Now"));
        $DateNow = date('Y-m-d H:i:s', strtotime('-2 minutes'));
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];


        $RaceDate = "";
        $RaceForTheRound = GetRacesRound($Round, $Date);
        if( isset($RaceForTheRound) && ($RaceForTheRound!==null) ) 
        {
            if ($RaceForTheRound!==false)
            {
                $RaceDate = $RaceForTheRound[0]['Date'] ." ". $RaceForTheRound[0]['Time'];
            }
        }

        $DateOK = true;
        if (isDate($RaceDate))
        {
            $interval = date_diff(date_create($DateNow), date_create($RaceDate));
            $interval2 = date_diff(date_create($RaceDate), date_create($DateNow));

            if (new DateTime($DateNow) > new DateTime($RaceDate))
            {
                $DateOK = false;
            }            
        }
        else
        {
            $DateOK = false;
        }

        if ($Admin == 1)
        {
            $DateOK = true;
        }

        if ($DateOK == false)
        {
            return true;
        }



        $db1 = new MySQLDb();
        $sql = "delete from userselection where UserName = \"$UserName\"  and Season = $Year and Round = $Round; ";
        if(!$db1 -> query($sql))
	    // if(!mysqli_query( $GLOBALS['db'], $insert_query))
        {
            //$this->HandleDBError("Error inserting data to the table\nquery:$insert_query");
			$Error = " Error: " .$sql .$db1->error();	
            return false;
        } 
        
        $sql = " INSERT INTO userselection (UserName, Season, `Round`) "
        ." VALUES (\"$UserName\",$Year, $Round);";
        if(!$db1 -> query($sql))
	    // if(!mysqli_query( $GLOBALS['db'], $insert_query))
        {
            //$this->HandleDBError("Error inserting data to the table\nquery:$insert_query");
			$Error = " Error: " .$sql .$db1->error();	
            return false;
        } 
        
        $sql = " UPDATE userselection SET DateTime = NOW(), 1stPlace = \""  .$stPlace ."\" , "
        ." 2ndPlace  = \""  .$ndPlace ."\" , 3rdPlace = \""  .$rdPlace ."\", "
        ." FatestLap = \""  .$UserFatestLap ."\""
        ."  WHERE UserName = \"" .$UserName . "\" and Round = $Round and Season = $Year";
        if(!$db1 -> query($sql))
	    // if(!mysqli_query( $GLOBALS['db'], $insert_query))
        {
            //$this->HandleDBError("Error inserting data to the table\nquery:$insert_query");
			$Error = " Error: " .$sql .$db1->error();	
            return false;
        } 
               
        return true;
        
    }

    function DeleteUserSelection($UserName,  $Date, $Round)
    {
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        $db1 = new MySQLDb();
        $sql = "delete from userselection 
        where UserName = \"$UserName\"  and Season = $Year 
        and Round = $Round; ";
        if(!$db1 -> query($sql))
        // if(!mysqli_query( $GLOBALS['db'], $insert_query))
        {
            //$this->HandleDBError("Error inserting data to the table\nquery:$insert_query");
            $Error = " Error: " .$sql .$db1->error();	
            return false;
        } 
        return true;
        
    }

    function GetResults( $Date, $Round)
    {

        if( $Round==null) 
        {
            $Round = 1;
        }

        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        $sql = "SELECT Season, Country, Position, Round, DriverName, Points ";
        $sql .= " FROM results WHERE Season = $Year and Round = $Round order by Season, Round, Position";
        //echo $sql;
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }

    function GetDriverResults($Date, $Round)
    {
        //return null;
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        // $sql = 
        // "SET @SQL = NULL;
        // SELECT
        // GROUP_CONCAT(DISTINCT
        //     CONCAT(
        //     'sum(case when Round = ',
        //     dn,
        //     ' then r.Points else 0 end) AS `r',
        //     dn, '`'
        //     )
        // ) INTO @SQL
        // FROM
        // (
        // SELECT DISTINCT Round dn
        // FROM results r
        // where `Season` = $Year
        // ORDER BY r.Round
        // ) d;
        
        // SET @SQL 
        // = CONCAT('SELECT r.DriverName, ', @SQL, '
        //             from results r
        //             where `Season` = $Year
        //             and `Points` > 0
        //             group by r.`DriverName`
        //             ORDER by sum(r.Points) DESC;');
        
        
        // PREPARE stmt FROM @SQL;
        // EXECUTE stmt;
        // DEALLOCATE PREPARE stmt;";

        // $sql = "CALL `UP_GetDriverResults`($Year);";
        
        $sql = "SELECT r.DriverName";
        for ($c=1; $c < $Round + 1; $c++)
        {
            $sql .= ", sum(case when Round = $c then r.Points else 0 end) AS `r$c`";
        }
        $sql .= "from results r
        where `Season` = $Year
        and `Points` > 0
        group by r.`DriverName`
        ORDER by sum(r.Points) DESC;";


        //echo $sql."<br/>";;

        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }

    function GetuserResultsforRound( $Date, $Round)
    {

        if( $Round==null) 
        {
            $Round = 1;
        }

        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        $sql = 
        "select c.*, IFNULL(reg.NAME,c.UserName)  as NAME, 
        IFNULL(ws.Value, 0) as WoreShirt, 
        IFNULL(bo.Value, 0) as BillOverR140, 
        IFNULL(wp.Value, 0) as WasPresent,
        (Point_1st + Point_2nd + Point_3rd) as total
        FROM regform reg
        left join 
        (
          select us.Season, us.Round, us.UserName, b.1stPlace, b.2ndPlace, b.3rdPlace
          , (case when b.1stPlace = us.1stPlace then 25 else 0 END) as Point_1st
          , (case when b.2ndPlace = us.2ndPlace then 18 else 0 END) as Point_2nd
          , (case when b.3rdPlace = us.3rdPlace then 15 else 0 END) as Point_3rd
          , (case when b.fastLap = us.FatestLap then 10 else 0 END) as FatestLap
          from userselection as us
          left JOIN
          (
            select *
            FROM
            (
                SELECT r1.`Season`, r1.`Round`,
                r1.`DriverName` as 1stPlace, r2.`DriverName` as 2ndPlace, r3.`DriverName` as 3rdPlace
                , fl.`DriverName` as fastLap
                FROM `results` as r1
                left join `results` as r2
                on r2.`Round` = r1.`Round`
                and r2.`Season` = r1.`Season`
                and r2.`Position` = 2
                left join `results` as r3
                on r3.`Round` = r1.`Round`
                and r3.`Season` = r1.`Season`
                and r3.`Position` = 3

                left join `results` as fl
                on fl.`Round` = r1.`Round`
                and fl.`Season` = r1.`Season`
                and fl.`Position` = 99

                WHERE r1.`Season` = $Year
                and r1.`Round` = $Round
                and r1.`Position` = 1
            ) as a
          ) as b 
          on b.`Season` = us.Season
          and b.`Round` = us.Round
          where us.Season = $Year
          and us.`Round` = $Round
          group by us.UserName
        ) as c
        on c.UserName = reg.username
        left join userextrapoints wp
            on wp.Round = c.round
            and wp.UserName = c.username
            and wp.Season = c.Season
            and REPLACE(wp.ExtraPointsName,' ','') = 'WasPresent'
        left join userextrapoints bo
            on bo.Round = c.round
            and bo.UserName = c.username
            and bo.Season = c.Season
            and REPLACE(bo.ExtraPointsName,' ','') = 'BillOverR140'
        left join userextrapoints ws
            on ws.Round = c.round
            and ws.UserName = c.username
            and ws.Season = c.Season
            and REPLACE(ws.ExtraPointsName,' ','') = 'WoreShirt' 
        
        order by (c.Point_1st + c.Point_2nd + c.Point_3rd + c.FatestLap) desc, IFNULL(reg.NAME,c.UserName);
        
        ";      
        //where (Point_1st + Point_2nd + Point_3rd) >= 0
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }

    function GetuserResultsforRound22( $Date, $Round)
    {

        if( $Round==null) 
        {
            $Round = 1;
        }

        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        $sql = 
        "select * from ( select c.*, IFNULL(reg.NAME,c.UserName)  as NAME, 
        (IFNULL(ws.Value, 0) * 10) as WoreShirt, 
        (IFNULL(bo.Value, 0) * 10) as BillOverR140, 
        IFNULL(wp.Value, 0) as WasPresent,
        ((Point_1st + Point_2nd + Point_3rd) * (IFNULL(wp.Value, 0) + 1) ) + FatestLap
        + (IFNULL(bo.Value, 0) * 10) + (IFNULL(ws.Value, 0) * 10) as total
        FROM regform reg
        left join 
        (
          select us.Season, us.Round, us.UserName, b.1stPlace, b.2ndPlace, b.3rdPlace
          , (case when b.1stPlace = us.1stPlace then 25 else 0 END) as Point_1st
          , (case when b.2ndPlace = us.2ndPlace then 18 else 0 END) as Point_2nd
          , (case when b.3rdPlace = us.3rdPlace then 15 else 0 END) as Point_3rd
          , (case when b.fastLap = us.FatestLap then 10 else 0 END) as FatestLap
          from userselection as us
          left JOIN
          (
            select *
            FROM
            (
                SELECT r1.`Season`, r1.`Round`,
                r1.`DriverName` as 1stPlace, r2.`DriverName` as 2ndPlace, r3.`DriverName` as 3rdPlace
                , fl.`DriverName` as fastLap
                FROM `results` as r1
                left join `results` as r2
                on r2.`Round` = r1.`Round`
                and r2.`Season` = r1.`Season`
                and r2.`Position` = 2
                left join `results` as r3
                on r3.`Round` = r1.`Round`
                and r3.`Season` = r1.`Season`
                and r3.`Position` = 3

                left join `results` as fl
                on fl.`Round` = r1.`Round`
                and fl.`Season` = r1.`Season`
                and fl.`Position` = 99

                WHERE r1.`Season` = $Year
                and r1.`Round` = $Round
                and r1.`Position` = 1
            ) as a
          ) as b 
          on b.`Season` = us.Season
          and b.`Round` = us.Round
          where us.Season = $Year
          and us.`Round` = $Round
          group by us.UserName
        ) as c
        on c.UserName = reg.username
        left join userextrapoints wp
            on wp.Round = c.round
            and wp.UserName = c.username
            and wp.Season = c.Season
            and REPLACE(wp.ExtraPointsName,' ','') = 'WasPresent'
        left join userextrapoints bo
            on bo.Round = c.round
            and bo.UserName = c.username
            and bo.Season = c.Season
            and REPLACE(bo.ExtraPointsName,' ','') = 'BillOverR140'
        left join userextrapoints ws
            on ws.Round = c.round
            and ws.UserName = c.username
            and ws.Season = c.Season
            and REPLACE(ws.ExtraPointsName,' ','') = 'WoreShirt' 
        ) aaaa
        order by (aaaa.total) desc
        , IFNULL(aaaa.NAME,aaaa.UserName) asc;
        
        ";      
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }

    function GetRLoadedImages()
    {     
        $sql = "SELECT id, name, image, enabled ";
        $sql .= " FROM images";
        //echo $sql;
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }

    function GetRLoadedImages2()
    {     
        $sql = "SELECT id, name, image, enabled ";
        $sql .= " FROM images where enabled = 1";
        //echo $sql;
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }

    function DeleteLoadedImages($imageID)
    {     
        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });
        $sql = "delete  FROM images where `images`.`id` = $imageID;";

        $db1 = new MySQLDb();
        if(!$db1 -> query($sql))
	    {
            echo "sql : NOT Sucssefull  $sql".'</br>';
        }
    }

    function InsertAnImages($target_file, $image_show, &$message)
    {     
        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });

        try 
        {
            // Insert record
            $sql = "insert into images(name, image) values('" .$target_file . "', '" .$image_show."')";
            //echo "sql : $query.".'</br>';   
            $db1 = new MySQLDb();
            if(!$db1 -> query($sql))
            {
                $message =  "sql : NOT Sucssefull.".'</br>'."error : " . $db1 -> error().'</br>';
                return;
            }

            $message =  "sql : Image Inserted Sucssefully."; 
            return;        
        }
        catch(Exception $e) 
        {
            $message =  'Message: ' .$e->getMessage();
        }
    }


    function UpdateAnImages($ID, $Value)
    {     
        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });
        $sql = "update images set enabled = $Value where `images`.`id` = $ID;";
        //echo $sql ."<br>";
        $db1 = new MySQLDb();
        if(!$db1 -> query($sql))
	    {
            echo "sql : NOT Sucssefull  $sql".'</br>';
            try
            {
                echo("Error description: " . $db1 -> error());
            }
            catch (Exception $e) {
                echo 'Caught exception: ',  $e->getMessage(), "\n";
            }            
        }   
    }



    function UpdateTempRaceResults($Date, $Round, $stPlace, $ndPlace, $rdPlace, $UserFatestLap)
    {
        $Error = -1;
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });
        $sql = "DELETE FROM `results` WHERE `Season` = $Year and `Round` = $Round ;";
        $db1 = new MySQLDb();
        if(!$db1 -> query($sql))
	    {
            $Error = 0;
        }
        
        if ($Error == -1)
        {            
            $Error = -1;
            $sql = "INSERT INTO `results`(`Season`, `Position`, `Round`, `DriverName`, `Points`) 
            VALUES ($Year, 1, $Round, \"$stPlace\", 25)";
            
            if(!$db1 -> query($sql))
            {
                $Error = 0;
            }
        }
        if ($Error == -1)
        {            
            $Error = -1;
            $sql = "INSERT INTO `results`(`Season`, `Position`, `Round`, `DriverName`, `Points`) 
            VALUES ($Year, 2, $Round, \"$ndPlace\", 18)";
            
            if(!$db1 -> query($sql))
            {
                $Error = 0;
            }
        }
        if ($Error == -1)
        {            
            $Error = -1;
            $sql = "INSERT INTO `results`(`Season`, `Position`, `Round`, `DriverName`, `Points`) 
            VALUES ($Year, 3, $Round, \"$rdPlace\", 15)";
            
            if(!$db1 -> query($sql))
            {
                $Error = 0;
            }
        }

        if ($Error == -1)
        {            
            $Error = -1;
            $sql = "INSERT INTO `results`(`Season`, `Position`, `Round`, `DriverName`, `Points`) 
            VALUES ($Year, 99, $Round, \"$UserFatestLap\", 0)";

            if(!$db1 -> query($sql))
            {
                $Error = 0;
            }
        }
        
    }

    function UpdateTempRaceResults2($Date,$Country,$Position,$Round,$Name,$Points)
    {
        $Error = -1;
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });
        $db1 = new MySQLDb();
        $sql = "INSERT INTO  results(Season, Country, Position, Round, DriverName, Points)";
        $sql .= " VALUES ($Year,\"$Country\",$Position,$Round,\"$Name\",$Points)";
                        
            
        if(!$db1 -> query($sql))
        {
            $Error = 0;
        }
        
        
    }


    function DeleteTempRaceResults($Date, $Round)
    {
        $Error = -1;
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });
        $sql = "DELETE FROM `results` WHERE `Season` = $Year and `Round` = $Round ;";
        
        $db1 = new MySQLDb();
        if(!$db1 -> query($sql))
	    {
            $Error = " Error: " .$insert_query .$db1 -> error();	
            return false;
        }
        
    }


    function GetuserResultsforRound2()
    {

        $Date = date('Y-m-d', strtotime("Now"));;
        
        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        $sql = 
        "select c.*, ra.Race,ra.Date as RaceDate,ra.Time as RaceTime,
         IFNULL(reg.NAME,c.UserName)  as NAME, 
         (IFNULL(ws.Value, 0) * 10) as WoreShirt, 
        (IFNULL(bo.Value, 0) * 10) as BillOverR140, 
        IFNULL(wp.Value, 0) as WasPresent,
        ((Point_1st + Point_2nd + Point_3rd ) + Point_FatestLap) as total,

        ((Point_1st + Point_2nd + Point_3rd) * (IFNULL(wp.Value, 0) + 1) ) + Point_FatestLap
        + (IFNULL(bo.Value, 0) * 10) + (IFNULL(ws.Value, 0) * 10) as totalOverall
        FROM regform reg
        left join 
        (
          select b.Season,us.Round, us.UserName, us.DateTime as TimeEntered,
          b.Place_1 as Place_1, b.Place_2 as Place_2, b.Place_3 as Place_3
          , b.Place_fastLap as Place_fastLap
          , us.1stPlace as UserPlace_1, us.2ndPlace as UserPlace_2
          , us.3rdPlace as UserPlace_3, us.FatestLap as UserFatestLap
          , (case when b.Place_1 = us.1stPlace then 25 else 0 END) as Point_1st
          , (case when b.Place_2 = us.2ndPlace then 18 else 0 END) as Point_2nd
          , (case when b.Place_3 = us.3rdPlace then 15 else 0 END) as Point_3rd
          , (case when b.Place_fastLap = us.FatestLap then 10 else 0 END) as Point_FatestLap
          from regform reg2
          left join userselection as us
                on us.UserName = reg2.username
          left JOIN
          (
            select *
            FROM
            (
                SELECT r1.`Season`, r1.`Round`,
                r1.`DriverName` as Place_1, r2.`DriverName` as Place_2
                , r3.`DriverName` as Place_3, fl.`DriverName` as Place_fastLap
                FROM `results` as r1
                left join `results` as r2
                on r2.`Round` = r1.`Round`
                and r2.`Season` = r1.`Season`
                and r2.`Position` = 2
                left join `results` as r3
                on r3.`Round` = r1.`Round`
                and r3.`Season` = r1.`Season`
                and r3.`Position` = 3
                left join `results` as fl
                on fl.`Round` = r1.`Round`
                and fl.`Season` = r1.`Season`
                and fl.`Position` = 99
                WHERE r1.`Season` = $Year
                and r1.`Position` = 1
            ) as a
          ) as b 
          on b.`Season` = us.Season
          and b.`Round` = us.Round
          where us.Season = $Year 
        ) as c
        on c.UserName = reg.username
        left join races ra
        on ra.Season = c.Season
        and ra.Round = c.Round  
        left join userextrapoints wp
            on wp.Round = c.round
            and wp.UserName = c.username
            and wp.Season = c.Season
            and REPLACE(wp.ExtraPointsName,' ','') = 'WasPresent'
        left join userextrapoints bo
            on bo.Round = c.round
            and bo.UserName = c.username
            and bo.Season = c.Season
            and REPLACE(bo.ExtraPointsName,' ','') = 'BillOverR140'
        left join userextrapoints ws
            on ws.Round = c.round
            and ws.UserName = c.username
            and ws.Season = c.Season
            and REPLACE(ws.ExtraPointsName,' ','') = 'WoreShirt' 
        order by c.Round, c.UserName   
        ";      
        
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }

        return null;
        
    }

    function GetAdministrators()
    {

        $sql = 
        "select UserName, NAME, IsAdmin
        FROM regform reg where USER_ENABLED = 1";      
        
        
        //echo $sql;
        
        $result = mysqli_query($GLOBALS['db'],$sql) or die(mysqli_error($GLOBALS['db']));
        $count = mysqli_num_rows($result);
        
        //$error = "Count drivers: " .$count;
        
        if($count >= 1) 
        {
            While ($row = mysqli_fetch_array($result,MYSQLI_ASSOC))
            {
                $Resultsrtc[] = array(
                    'UserName' => $row['UserName'],
                    'Name' => $row['NAME'],
                    'IsAdmin' => $row['IsAdmin']
                );
            }
        }
        else 
        {
            
        }
        
        mysqli_free_result($result);
        
        if (isset($Resultsrtc))
        {
            return $Resultsrtc;
        }
        else
        {
            return null;
        }
        
    }


    function GetExtraPoints($Date, $Round)
    {
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        // $sql = 
        // "SET @SQL = NULL;
        // SELECT
        // GROUP_CONCAT(DISTINCT
        //     CONCAT(
        //     'sum(case when REPLACE(ExtraPointsName,'' '','''') = ''',
        //     dn,
        //     ''' then 1 else 0 end) AS `r',
        //     REPLACE(dn,' ',''), '`'
        //     )
        // ) INTO @SQL
        // FROM
        // (
        // SELECT DISTINCT REPLACE(Name,' ','') dn
        // FROM extrapoints r
        // where `Season` = $Year
        // and `Enabled`  = 1
        // ORDER BY r.Name
        // ) d;

        // SET @SQL 
        //     = CONCAT('SELECT r.UserName, r.NAME, ue.Round, ', @SQL, '
		// 	from regform r
		// 	left join userextrapoints ue
		// 	 on r.username = ue.UserName
        //      and ue.`Season` = $Year
        //      and ue.`Round` = $Round
        //      group by r.`UserName`;');
        
        
        // PREPARE stmt FROM @SQL;
        // EXECUTE stmt;
        // DEALLOCATE PREPARE stmt;";
        
        // //echo $sql."<br/>";;

        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });
        //$sql = "CALL `UP_ExtraPoints`('$Year', '$Round')";
        $sql = "SELECT r.UserName, r.NAME, ue.Round
        ,sum(case when REPLACE(ExtraPointsName,' ','') = 'BillOverR140' then 1 else 0 end) AS `rBillOverR140`
        ,sum(case when REPLACE(ExtraPointsName,' ','') = 'WasPresent' then 1 else 0 end) AS `rWasPresent`
        ,sum(case when REPLACE(ExtraPointsName,' ','') = 'WoreShirt' then 1 else 0 end) AS `rWoreShirt`
            from regform r
            left join userextrapoints ue
             on r.username = ue.UserName
             and ue.`Season` = $Year
             and ue.`Round` = $Round
             group by r.`UserName`, r.NAME
             order by r.`NAME`;";
        
        $db1 = new MySQLDb();




        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }

        return null;
 
        
    }



    function GetUserStandings($Date, $Round)
    {
        //return null;
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        // $sql = 
        // "SET @SQL = NULL;
        // SELECT
        // GROUP_CONCAT(DISTINCT
        //     CONCAT(
        //     'sum(case when round = ',
        //     dn,
        //     ' then d.PointsTotal else 0 end) AS `r',
        //     dn, '`'
        //     )
        // ) INTO @SQL
        // FROM
        // (
        // SELECT DISTINCT Round dn
        // FROM results r
        // where `Season` = $Year
        // ORDER BY r.Round
        // ) d;
        
        // SET @SQL 			
        // = CONCAT('select NAME, ', @SQL, '
        // from
        // (	
        //     select  NAME, username, round, Points1, Points2, Points3, FastLap,
        //     ((Points1+ Points2+ Points3)+FastLap) as  PointsTotal
        //     from 
        //     (
        //         select NAME, username, a.round, UserPlace1, UserPlace2, UserPlace3, Place1, Place2, Place3,
        //         case 
        //         when UserPlace1 = Place1 then 25
        //         else 0
        //         end as Points1,
        //         case when UserPlace2 = Place2 then 18
        //         else 0
        //         end as Points2,
        //         case when UserPlace3 = Place3 then 15
        //         else 0
        //         end as Points3,
        //         case when UserFatestLap = PlaceFastLap then 10
        //         else 0
        //         end as FastLap
        //         from 
        //         (
        //             select r.NAME, r.username, round, 1stPlace as UserPlace1, 
        //             2ndPlace as UserPlace2, 
        //             3rdPlace as UserPlace3,
        //             FatestLap as UserFatestLap
        //             from regform r
        //             left join userselection us
        //                 on us.UserName = r.username
        //             where us.Season = $Year
        //             group by r.NAME, r.username, round
        //         ) as a
        //         left join 
        //         (
        //             SELECT r1.`Season`, r1.`Round`,
        //           r1.`DriverName` as Place1, 
        //           r2.`DriverName` as Place2, 
        //           r3.`DriverName` as Place3,
        //           fl.`DriverName` as PlaceFastLap
        //           FROM `results` as r1
        //           left join `results` as r2
        //           on r2.`Round` = r1.`Round`
        //           and r2.`Season` = r1.`Season`
        //           and r2.`Position` = 2
        //           left join `results` as r3
        //           on r3.`Round` = r1.`Round`
        //           and r3.`Season` = r1.`Season`
        //           and r3.`Position` = 3
        //           left join `results` as fl
        //           on fl.`Round` = r1.`Round`
        //           and fl.`Season` = r1.`Season`
        //           and fl.`Position` = 99
        //           WHERE r1.`Season` = 
        //           and r1.`Position` = 1
        //         ) as b 
        //         on b.Round = a.round
        //         order by a.round
        //     ) as c
        //     order by c.round		
        // ) as d
        // group by d.NAME
        // ORDER by sum(d.PointsTotal) DESC, d.NAME;');
        
        // PREPARE stmt FROM @SQL;
        // EXECUTE stmt;
        // DEALLOCATE PREPARE stmt;";
        

        // $sql = "CALL `UP_GetUserStandings`($Year)";

        $sql = "select NAME";
        
        for ($c=1; $c < $Round + 1; $c++)
        {
            $sql .= ", sum(case when round = $c then d.PointsTotal else 0 end) AS `r$c` ";

        }
        
        $sql .= "from
            (	
                select  NAME, username, round, Points1, Points2, Points3, FastLap,
                ((Points1+ Points2+ Points3)+FastLap) as  PointsTotal
                from 
                (
                    select NAME, username, a.round, UserPlace1, UserPlace2, UserPlace3, Place1, Place2, Place3,
                    case 
                    when UserPlace1 = Place1 then 25
                    else 0
                    end as Points1,
                    case when UserPlace2 = Place2 then 18
                    else 0
                    end as Points2,
                    case when UserPlace3 = Place3 then 15
                    else 0
                    end as Points3,
                    case when UserFatestLap = PlaceFastLap then 10
                    else 0
                    end as FastLap
                    from 
                    (
                        select r.NAME, r.username, round, 1stPlace as UserPlace1, 
                        2ndPlace as UserPlace2, 
                        3rdPlace as UserPlace3,
                        FatestLap as UserFatestLap
                        from regform r
                        left join userselection us
                            on us.UserName = r.username
                        where us.Season = $Year
                        group by r.NAME, r.username, round
                    ) as a
                    left join 
                    (
                        SELECT r1.`Season`, r1.`Round`,
                    r1.`DriverName` as Place1, 
                    r2.`DriverName` as Place2, 
                    r3.`DriverName` as Place3,
                    fl.`DriverName` as PlaceFastLap
                    FROM `results` as r1
                    left join `results` as r2
                    on r2.`Round` = r1.`Round`
                    and r2.`Season` = r1.`Season`
                    and r2.`Position` = 2
                    left join `results` as r3
                    on r3.`Round` = r1.`Round`
                    and r3.`Season` = r1.`Season`
                    and r3.`Position` = 3
                    left join `results` as fl
                    on fl.`Round` = r1.`Round`
                    and fl.`Season` = r1.`Season`
                    and fl.`Position` = 99
                    WHERE r1.`Season` = $Year
                    and r1.`Position` = 1
                    ) as b 
                    on b.Round = a.round
                    order by a.round
                ) as c
                order by c.round		
            ) as d
            group by d.NAME
            ORDER by sum(d.PointsTotal) DESC, d.NAME;  "; 


        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }

    function UpDateExtras($UserName, $Date, $Round, $WasPresent
                , $BillOverR140, $WoreShirt)
    {     
        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });

        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];
        
        $db1 = new MySQLDb();
        $sql = "delete from `userextrapoints` where `UserName` = \"$UserName\"  and `Season` = $Year and `Round` = $Round;";
        if(!$db1 -> query($sql))
	    // if(!mysqli_query( $GLOBALS['db'], $insert_query))
        {
            //$this->HandleDBError("Error inserting data to the table\nquery:$insert_query");
			$Error = " Error: " .$sql .$db1->error();	
            return false;
        } 
        
        
        
        
        if ($WasPresent == true)
        {
            $sql = "INSERT INTO userextrapoints (UserName, Season, `Round`, ExtraPointsName, `value`) "
                ." VALUES ('$UserName',$Year, $Round, 'Was Present', 1);";
            if(!$db1 -> query($sql))
            {
                $Error = " Error: " .$sql .$db1 -> error();	
                //return false;
            }
        }

        if ($BillOverR140 == true)
        {
            $sql = " INSERT INTO userextrapoints (UserName, Season, `Round`, ExtraPointsName, `value`) "
                ." VALUES ('$UserName',$Year, $Round, 'Bill Over R140', 1);";
            if(!$db1 -> query($sql))
            {
                $Error = " Error: " .$sql .$db1 -> error();	
                //return false;
            }
        }

        if ($WoreShirt == true)
        {
            $sql = " INSERT INTO userextrapoints (UserName, Season, `Round`, ExtraPointsName, `value`) "
                ." VALUES ('$UserName',$Year, $Round, 'Wore Shirt', 1);";

            if(!$db1 -> query($sql))
            {
                $Error = " Error: " .$sql .$db1 -> error();	
                //return false;
            }
        }

        return true;
    }


    function GetUserStandingsOverAll($Date)
    {
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        $sql = "call UP_GetUserStandings2($Year);";
        
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }
    
    
    function UpdateAutoUpdate($Date, $Round)
    {     
        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));;
        }

        $split_date = explode("-", $Date);
        $Year = $split_date[0];

        set_error_handler(function($errno, $errstr, $errfile, $errline ){
            throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
        });

        $sql = "insert into autoupdate (Season, Race, `DateTime`)
        values ($Year, $Round, NOW())";
        
        $db1 = new MySQLDb();
        if(!$db1 -> query($sql))
	    {
            $Error = " Error: " .$sql .$db1->error();	
            return false;
        } 
               
        return true; 
    }

    function GetAutoUpdateRound($Round, $Date)
    {
        if( $Round==null) 
        {
            $Round = 0;
        }

        if( $Date==null) 
        {
            $Date = date('Y-m-d', strtotime("Now"));            
        }
        
        $split_date = explode("-", $Date);
        $Season = $split_date[0];

        $sql = "SELECT * FROM autoupdate where Season = $Season and Race = $Round order by DateTime;";
        $db1 = new MySQLDb();
        $rows = $db1 -> select($sql);

        if (isset($rows))
        {
            if (count($rows) > 0)
            {
                return $rows;
            }
        }
        return null;
        
    }
?>