<?php
set_include_path( get_include_path().PATH_SEPARATOR."..");
include_once("classes/xlsxwriter.class.php");
require_once('Queries.php');

$Round = 0;
$Date = date('Y-m-d', strtotime("Now"));;;

if (isset($_GET["Round"]))
{
    $Round = $_GET["Round"];
}

if (isset($_GET["Date"]))
{
    $Date = $_GET["Date"];
}

$userResultsforRounds = GetuserResultsforRound2();

exportUserResultsToexcel($userResultsforRounds);

function exportUserResultsToexcel($userResultsforRounds)
{
  $filename = "F1Paparazzi.xlsx";
  header('Content-disposition: attachment; filename="'.XLSXWriter::sanitize_filename($filename).'"');
  header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
  header('Content-Transfer-Encoding: binary');
  header('Cache-Control: must-revalidate');
  header('Pragma: public');

  $header = array(
    'Round'=>'string',//text
    'Name'=>'@',//text
    'Date Entered'=>'string', //'YYYY-MM-DD HH:mm:ss',
    '1st place'=>'string',//text
    '2nd place'=>'string',//text
    '3rd place'=>'string',//text
    'Fastest Lap'=>'string',//text
    'WasPresent'=>'string',//text
    'WoreShirt'=>'string',//text
    'BillOverR140'=>'string',//text
    'Points Race'=>'integer',//text
    'Total Race'=>'integer',//text
  );


  $header2 = array(
    'Round',
    'Date',
    'Race',
    '1st place',
    '2nd place',
    '3rd place',
    'Fastest Lap',
  );

  
  $writer = new XLSXWriter();

  
  $styles1 = array( 'font'=>'Arial','font-size'=>10,'font-style'=>'bold', 'fill'=>'#ffff66', 'halign'=>'center', 'border'=>'left,right,top,bottom');
  $styles2 = array( 'font'=>'Arial','font-size'=>10,'font-style'=>'bold', 'halign'=>'center', 'border'=>'left,right,top,bottom');

  $writer->writeSheetHeader('User Scores', $header, $styles1);
  // $writer->writeSheetRow('Sheet1P', $header, $rowstyle);
  if( isset($userResultsforRounds) && ($userResultsforRounds!==null) )
  {
    // foreach($userResultsforRounds as $userResultsforRound)
    foreach ($userResultsforRounds as $key => $val) 
    {
      $mRound = $val['Round'];
      $mName = $val['NAME'];
      $mUserName = $val['UserName'];
      $mTimeEntered = $val['TimeEntered'];
      $mPlace_1 = $val['UserPlace_1'];
      $mPlace_2 = $val['UserPlace_2'];
      $mPlace_3 = $val['UserPlace_3'];
      $mFastLap = $val['UserFatestLap'];
      $mTotal = $val['total'];

      $mWoreShirt = $val['WoreShirt'];
      $mBillOverR140 = $val['BillOverR140'];
      $mWasPresent = $val['WasPresent'];
      $mTotalOverall = $val['totalOverall'];


      $mWasPresent2 = "No";
      if ($mWasPresent > 0)
      {
          $mWasPresent2 = "Yes";
      }

      $mWoreShirt2 = "No";
      if ($mWoreShirt > 0)
      {
          $mWoreShirt2 = "Yes";
      }

      $mBillOverR1402 = "No";
      if ($mBillOverR140 > 0)
      {
          $mBillOverR1402 = "Yes";
      }

      $ArrayXLS = array
      (
        $mRound,
        utf8_encode($mName),
        $mTimeEntered,
        utf8_encode($mPlace_1),
        utf8_encode($mPlace_2),
        utf8_encode($mPlace_3),
        utf8_encode($mFastLap),
        $mWasPresent2,
        $mWoreShirt2,
        $mBillOverR1402,
        $mTotal,
        $mTotalOverall,
      );
      
      $writer->writeSheetRow('User Scores', $ArrayXLS, $styles2);
    }

    $writer->writeSheetRow('User Scores', $rowdata = array('','','',''), $styles2);
    $writer->writeSheetRow('User Scores', $rowdata = array('','','',''), $styles2);
      
    $writer->writeSheetRow('User Scores', $header2, $styles1);


    $roundNumber = 0;
            
    foreach ($userResultsforRounds as $key => $val) 
    {
      $mRound = $val['Round'];
      $mName = $val['NAME'];
      $mUserName = $val['UserName'];
      $mTimeEntered = $val['TimeEntered'];
      $mPlace_1 = $val['Place_1'];
      $mPlace_2 = $val['Place_2'];
      $mPlace_3 = $val['Place_3'];
      $mFastLap = $val['Place_fastLap'];
      $mTotal = $val['total'];
      
      $mRace = $val['Race'];
      $mRaceDate = $val['RaceDate'];
      $mRaceTime = $val['RaceTime'];
      
      $mDateTime = "";
      if( isset($mRaceDate) && ($mRaceDate!==null) &&
          isset($mRaceTime) && ($mRaceTime!==null))
      {
          $mDateTime = $mRaceDate ." " .$mRaceTime;
      }           

      if($roundNumber != $mRound)
      {
        $writer->writeSheetRow('User Scores', $rowdata = array($mRound,
        $mDateTime,
        utf8_encode($mRace),
        utf8_encode($mPlace_1),
        utf8_encode($mPlace_2),
        utf8_encode($mPlace_3),
        utf8_encode($mFastLap)), $styles2);
        $roundNumber = $mRound;
      }
    }
  }
  $writer->writeToStdOut(); 
  exit(0);
}

